/**
 * BodyInfo.h 
 * BodyInfo contains 3D-coordinate of all points that can be tracked by kinect
 */

#ifndef _BODYINFO_H_
#define _BODYINFO_H_
#include "KinectFunction.h"

class BodyInfo
{
public:
	bool bTracking;
	XnPoint3D pHead; bool bHead;
	XnPoint3D pNeck; bool bNeck;
	XnPoint3D pLShoulder; bool bLShoulder;
	XnPoint3D pRShoulder; bool bRShoulder;
	XnPoint3D pLElbow; bool bLElbow;
	XnPoint3D pRElbow; bool bRElbow;
	XnPoint3D pLHand; bool bLHand;
	XnPoint3D pRHand; bool bRHand;
	XnPoint3D pTorso; bool bTorso;
	XnPoint3D pLHip; bool bLHip;
	XnPoint3D pRHip; bool bRHip;
	XnPoint3D pLKnee; bool bLKnee;
	XnPoint3D pRKnee; bool bRKnee;
	XnPoint3D pLFoot; bool bLFoot;
	XnPoint3D pRFoot; bool bRFoot;
public:
	BodyInfo(void);
	~BodyInfo(void);
};
#endif

